#! /bin/bash

# A bit circular; we're trying to build a newer wget, not bootstrap a system.
wget -c http://www.openssl.org/source/openssl-1.0.0f.tar.gz
if [ ! -d openssl-1.0.0f ] ; then
 tar -zxvf openssl-1.0.0f.tar.gz
 pushd openssl-1.0.0f
  ./configure --prefix=/mingw -no-shared -no-zlib-dynamic -no-test mingw
  make
  make install
 popd
fi

wget -c http://ftp.gnu.org/gnu/wget/wget-1.13.4.tar.gz

TEMP_INSTALL=$PWD/temp-install

if [ ! -d wget-1.13.4 ] ; then
 tar -zxvf wget-1.13.4.tar.gz
 pushd wget-1.13.4
# Because openssl doesn't seem to generate libtool .la files, this patch is needed.
# It re-orders the libs so that the static libssl libraries appear before their
# dependencies.
printf %s \
'--- wget-1.13.4-orig/configure.orig	2012-01-10 11:47:24 +0000
+++ wget-1.13.4-orig/configure	2012-01-10 11:47:54 +0000
@@ -30054,6 +30054,7 @@
 
     ac_save_LIBS="$LIBS"
                                 case " $LIBSSL" in
+      *".a"*)   LIBS="$LIBSSL $LIBS" ;;
       *" -l"*) LIBS="$LIBS $LIBSSL" ;;
       *)       LIBS="$LIBSSL $LIBS" ;;
     esac
@@ -30781,6 +30782,7 @@
 
     ac_save_LIBS="$LIBS"
                                 case " $LIBGNUTLS" in
+      *".a"*)   LIBS="$LIBGNUTLS $LIBS" ;;
       *" -l"*) LIBS="$LIBS $LIBGNUTLS" ;;
       *)       LIBS="$LIBGNUTLS $LIBS" ;;
     esac
' > linkorder.patch
  patch -p1 < linkorder.patch
 popd
fi

if [ ! -d build/wget ] ; then
 mkdir -p build/wget
 pushd build/wget
  LDFLAGS="-static-libgcc" ../../wget-1.13.4/configure --prefix=/mingw --enable-threads=win32 --disable-nls --enable-static --disable-shared --with-ssl=openssl
  make
  DESTDIR=$TEMP_INSTALL make install
 popd
fi

cp $0 $TEMP_INSTALL/mingw/
[ -f wget-1.13.4-static-mingw.7z ] && rm wget-1.13.4-static-mingw.7z
pushd $TEMP_INSTALL/mingw
 7za a ../../wget-1.13.4-static-mingw.7z *
popd
